package gov.va.vinci.dart.db.impl;

import java.sql.ResultSet;
import java.sql.SQLException;

import gov.va.vinci.dart.biz.Group;
import gov.va.vinci.dart.biz.Request;
import gov.va.vinci.dart.biz.RequestSummary;
import gov.va.vinci.dart.biz.WorkflowSummary;

/**
 * Retrieves all requests for the specified review group.  Used for review groups other than NDS.
 */
public class RequestSummaryForGroupBuilder {

	public RequestSummary build(final ResultSet rs) throws SQLException {
		
		RequestSummary result = new RequestSummary();
		WorkflowSummary workflowSummary = new WorkflowSummary();

		//result.setStatus(rs.getInt(1));
		workflowSummary.setStatus(rs.getInt(24));	//overall workflow status
		
		result.setRequestId(rs.getInt(3));
		result.setActivityId(rs.getInt(2));
		result.setTrackingNumber(rs.getString(4));
		
		result.setReviewId(rs.getInt(5));	//reviewId (intermediate review groups, review groups other than NDS)

		
		workflowSummary.setWorkflowId(rs.getInt(22));	//workflowId (top-level vs. child workflow)
		
		rs.getInt(23);
		if( rs.wasNull() == true ) {
			workflowSummary.setWorkflowTemplateId(0);	//default to workflowTemplateId = 0
		} else { 
			workflowSummary.setWorkflowTemplateId(rs.getInt(23));
		}		
		

		rs.getInt(25);
		if( rs.wasNull() == true ) {
			Group.initialize();
			workflowSummary.setWorkflowGroupId(Group.NDS.getId());	//default to NDS (legacy data)
		} else {
			workflowSummary.setWorkflowGroupId(rs.getInt(25));	//top-level group
		}
		
		
		rs.getString(6);
		if (rs.wasNull()) {
			result.setActivityName(rs.getString(7));
		} else if (rs.getString(6).trim().length() == 0) {
			result.setActivityName(rs.getString(7));
		} else {
			result.setActivityName(rs.getString(6));
		}
		

		rs.getDate(9);
		if( rs.wasNull() == false ) {
			result.setSubmittedOn( rs.getDate(9) );
		} else {
			result.setSubmittedOn( rs.getDate(8) );
		}
		
		result.setUpdatedOn(rs.getTimestamp(10));
		
		
		result.setTotalReviews(rs.getInt(12));	//not currently used (part of the elaborate status)
		result.setCompletedReviews(rs.getInt(13));

		result.setType(rs.getInt(11));
		
		rs.getString(14);
		if( rs.wasNull() == false) {
			result.setPrincipalInvestigatorName(rs.getString(14));	//Fullname
			result.setRetrievedPrincipalInvestigatorName(true);
		}
		
		rs.getInt(18);
		if (rs.wasNull() == false) {
			result.setDaysElapsed(rs.getInt(18));	// FinalEventTimeDiffInDays - need to append a 'days'
		}
		
		
		workflowSummary.setRequestState((rs.getString(15)));	//includes the "elaborate status" for this request
		
		result.setRequestType(rs.getString(19));
		
		//TODO:  PII - Clean this up after testing
        if (result.getRequestType() != null) {
            if (result.getRequestType().equals(Request.DATA_ACCESS)) {
                result.setResearchRequest(true);
            } else if (result.getRequestType().equals(Request.PREPARATORY_TO_RESEARCH_ACCESS)) {
                result.setPreparatoryRequest(true);
            } else if (result.getRequestType().equals(Request.OPERATIONS_DATA_ACCESS)) {
                result.setOperationsRequest(true);
            }
        }
		
		int isResearch = rs.getInt(20);

		/*if (isResearch == 1) {
			result.setResearchRequest(true);
		} else if (isResearch == 2) {
            result.setPreparatoryRequest(true);
        }else {
			result.setOperationsRequest(true);
		}*/
		
		int isEditable = rs.getInt(16);					
		if (isEditable == 1) {
			result.setEditable(true);						
		}
		
		int isAmendable = rs.getInt(17);
		if (isAmendable == 1) {
			result.setAmendable(true);						
		}
	
		result.getWorkflowSummaryList().add( workflowSummary );
		return result;
	}
	
}